flatcurry-elim-newtype
======================

This packages contains the library `FlatCurry.ElimNewtype` which
defines operations to eliminate definitions and uses
of `newtype` in a FlatCurry program.

If there is a declaration of the form

    newtype NTYPE a1...an = NTCONS te

in a Curry program, the following transformations are preformed:

* Replace the `newtype` declaration by a `data` declaration.
* Every type application `(NTYPE t1...tn)` is replaced by
  `{a1 |-> t1,..., an |-> tn}(te)`
  except for occurrences in instance definitions, i.e., operations
  named by `_inst#...`.
* A constructor application `(NTCONS e)` is replaced by `e`.
* A partial constructor application `(NTCONS)` is replaced by
  `(Prelude.id)`.
* A case expression `(f)case x of { NTCONS y -> e}` is replaced by
  `{y |-> x}(e)`.

The implementation requires also the interfaces of imported modules
to find all uses of `newtype` in the module to be transformed.
Furthermore, types are reconstructed in the FlatCurry program
since one transformation requires type information.
