------------------------------------------------------------------------------
-- | Author:  Michael Hanus
--   Version: November 2025
--
-- Some support to test the library `FlatCurry.ElimNewtype`.
--
------------------------------------------------------------------------------

module TestElimNewtype
 where

import FlatCurry.ElimNewtype
import FlatCurry.Files    ( readFlatCurry )
import FlatCurry.Pretty   ( showPrettyProg )
import FlatCurry.Types

------------------------------------------------------------------------------
-- For testing:

testElimNewtype :: String -> IO ()
testElimNewtype mn = do
  prog <- readFlatCurry mn
  elimNewtypeInProg prog >>= putStrLn . showPrettyProg

testNT :: IO ()
testNT = testElimNewtype "NT"

testNT1 :: IO ()
testNT1 = testElimNewtype "NT1"

-----------------------------------------------------------------------
